// https://randomnerdtutorials.com/esp32-web-server-spiffs-spi-flash-file-system/
// Load Wi-Fi library
#include <Arduino.h>
#ifdef ESP32
#include <WiFi.h>
#include <AsyncTCP.h>
#include <WiFiMulti.h>
#elif defined(ESP8266)
#include <ESP8266WiFi.h>
#include <ESPAsyncTCP.h>
#include <ESP8266WiFiMulti.h>
#endif
#include <WebSocketsServer.h>
#include <WiFiClient.h>
#include <ESPAsyncWebServer.h>
#include <SPIFFS.h>
#include <Adafruit_NeoPixel.h>

// Set LED GPIO
const int ledPin = 2;
// Stores LED state
String ledState;

#define LED_COUNT 12
#define LED_PIN 4
#define DELAYVAL 500
#define colorSaturation 255
Adafruit_NeoPixel strip(LED_COUNT, LED_PIN, NEO_GRB + NEO_KHZ800);

// Replace with your network credentials / softAP: http://192.168.4.1/
const char* ssid     = "WIFI_SHOE";
const char* password = "wifishoe123";

// Create AsyncWebServer object on port 80
AsyncWebServer server(80);
WebSocketsServer webSocket = WebSocketsServer(81);

// Replaces placeholder with LED state value
String processor(const String& var){
  Serial.println(var);
  if(var == "STATE"){
    if(digitalRead(ledPin)){
      ledState = "ON";
    }
    else{
      ledState = "OFF";
    }
    Serial.print(ledState);
    return ledState;
  }
  return String();
}

// reset all leds to off
void blackout() {
  for (int i = 0; i < strip.numPixels(); i++) {
    strip.setPixelColor(i, 0);
    strip.show();
  }
}

// Fill the dots one after the other with a color
void colorWipe(uint32_t c, uint8_t wait) {
  blackout();
  for(uint16_t i=0; i<strip.numPixels(); i++) {
      strip.setPixelColor(i, c);
      strip.show();
      delay(wait);
  }
  strip.show();
}

// make smiley
void smiley() {
  blackout();
  strip.setPixelColor(1, strip.Color(0, 150, 0));
  strip.setPixelColor(4, strip.Color(0, 150, 0));
  strip.setPixelColor(5, strip.Color(0, 150, 0));
  strip.setPixelColor(6, strip.Color(0, 150, 0));
  strip.setPixelColor(7, strip.Color(0, 150, 0));
  strip.setPixelColor(8, strip.Color(0, 150, 0));
  strip.setPixelColor(11, strip.Color(0, 150, 0));
  strip.show();
}

void setup() {
  Serial.begin(115200);
  pinMode(ledPin, OUTPUT);

   // Initialize SPIFFS
  if(!SPIFFS.begin(true)){
    Serial.println("An Error has occurred while mounting SPIFFS");
    return;
  }
  
  // Connect to Wi-Fi network with SSID and password
  // WiFi.begin(ssid, password);
  // while (WiFi.status() != WL_CONNECTED) {
    //delay(1000);
    //Serial.println("Connecting to WiFi..");
  // }
  // Serial.println(WiFi.localIP());
  WiFi.softAP(ssid, password);
  IPAddress myIP = WiFi.softAPIP();
  
  // Route for root / web page
  server.on("/", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send(SPIFFS, "/index.html", String(), false, processor);
  });
  
  // Route to load css-file
  server.on("/bootstrap.css", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send(SPIFFS, "/bootstrap.css", "text/css");
  });

  // Route to load js-file
  server.on("/jquery-latest.min.js", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send(SPIFFS, "/jquery-latest.min.js", "text/javascript");
  });

  // Route to load js-file
  server.on("/popper.js", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send(SPIFFS, "/popper.js", "text/javascript");
  });

  // Route to load js-file
  server.on("/bootstrap.js", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send(SPIFFS, "/bootstrap.js", "text/javascript");
  });

  // Route to set GPIO to HIGH/GREEN
  server.on("/on", HTTP_GET, [](AsyncWebServerRequest *request){
    digitalWrite(ledPin, HIGH);
    //colorWipe(strip.Color(0, 255, 0), 50); 
    smiley();
    request->send(SPIFFS, "/index.html", String(), false, processor);
  });
  
  // Route to set GPIO to LOW
  server.on("/off", HTTP_GET, [](AsyncWebServerRequest *request){
    digitalWrite(ledPin, LOW);
    colorWipe(strip.Color(0, 0, 0), 50);  
    request->send(SPIFFS, "/index.html", String(), false, processor);
  });

  // Route to set GPIO to RED
  server.on("/red", HTTP_GET, [](AsyncWebServerRequest *request){
    digitalWrite(ledPin, HIGH);
    colorWipe(strip.Color(255, 0, 0), 50); 
    request->send(SPIFFS, "/index.html", String(), false, processor);
  });

  // Route to set GPIO to BLUE
  server.on("/blue", HTTP_GET, [](AsyncWebServerRequest *request){
    digitalWrite(ledPin, HIGH);
    colorWipe(strip.Color(0, 0, 255), 50); 
    request->send(SPIFFS, "/index.html", String(), false, processor);
  });

  // Route to set GPIO to YELLOW
  server.on("/yellow", HTTP_GET, [](AsyncWebServerRequest *request){
    digitalWrite(ledPin, HIGH);
    colorWipe(strip.Color(255, 255, 0), 50);  
    request->send(SPIFFS, "/index.html", String(), false, processor);
  });

  // Route to set GPIO to BRIGHT
  server.on("/bright", HTTP_GET, [](AsyncWebServerRequest *request){
    digitalWrite(ledPin, HIGH);
    strip.setBrightness(100); 
    strip.show();
    request->send(SPIFFS, "/index.html", String(), false, processor);
  });

  // Route to set GPIO to DIMM
  server.on("/dimm", HTTP_GET, [](AsyncWebServerRequest *request){
    digitalWrite(ledPin, HIGH);
    strip.setBrightness(20); 
    strip.show();
    request->send(SPIFFS, "/index.html", String(), false, processor);
  });

  // Start server
  server.begin();

  // Initialize NeoPixel Strip
  strip.begin();
}

void loop(){
}
