/*
 * Decompiled with CFR 0.152.
 */
package com.esp8266.mkspiffs;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;
import org.apache.commons.codec.digest.DigestUtils;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.PreferencesData;
import processing.app.Sketch;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.FileUtils;
import processing.app.helpers.ProcessUtils;
import processing.app.tools.Tool;

public class ESP8266FS
implements Tool {
    Editor editor;

    public void init(Editor editor) {
        this.editor = editor;
    }

    public String getMenuTitle() {
        return "ESP8266 Sketch Data Upload";
    }

    private int listenOnProcess(String[] stringArray) {
        try {
            final Process process = ProcessUtils.exec((String[])stringArray);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        int n;
                        InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                        while ((n = inputStreamReader.read()) != -1) {
                            System.out.print((char)n);
                        }
                        inputStreamReader.close();
                        inputStreamReader = new InputStreamReader(process.getErrorStream());
                        while ((n = inputStreamReader.read()) != -1) {
                            System.err.print((char)n);
                        }
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread.start();
            int n = process.waitFor();
            thread.join();
            return n;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private void sysExec(final String[] stringArray) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    if (ESP8266FS.this.listenOnProcess(stringArray) != 0) {
                        ESP8266FS.this.editor.statusError("SPIFFS Upload failed!");
                    } else {
                        ESP8266FS.this.editor.statusNotice("SPIFFS Image Uploaded");
                    }
                }
                catch (Exception exception) {
                    ESP8266FS.this.editor.statusError("SPIFFS Upload failed!");
                }
            }
        };
        thread.start();
    }

    private String getBuildFolderPath(Sketch sketch) {
        try {
            String string = sketch.getBuildPath().getAbsolutePath();
            return string;
        }
        catch (IOException iOException) {
            this.editor.statusError((Exception)iOException);
        }
        catch (Exception exception) {
            try {
                File file = FileUtils.createTempFolder((String)"build", (String)(DigestUtils.md5Hex((String)sketch.getMainFilePath()) + ".tmp"));
                return file.getAbsolutePath();
            }
            catch (IOException iOException) {
                this.editor.statusError((Exception)iOException);
            }
            catch (Exception exception2) {
                try {
                    Method method = BaseNoGui.class.getMethod("getBuildFolder", new Class[0]);
                    File file = (File)method.invoke(null, new Object[0]);
                    return file.getAbsolutePath();
                }
                catch (SecurityException securityException) {
                    this.editor.statusError((Exception)securityException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.editor.statusError((Exception)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.editor.statusError((Exception)invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.editor.statusError((Exception)noSuchMethodException);
                }
            }
        }
        return "";
    }

    private long getIntPref(String string) {
        String string2 = (String)BaseNoGui.getBoardPreferences().get((Object)string);
        if (string2 == null || string2.contentEquals("")) {
            return 0L;
        }
        if (string2.startsWith("0x")) {
            return Long.parseLong(string2.substring(2), 16);
        }
        return Integer.parseInt(string2);
    }

    /*
     * WARNING - void declaration
     */
    private void createAndUpload() {
        void var20_22;
        File[] fileArray;
        Object object;
        String[] stringArray;
        long l;
        long l2;
        long l3;
        long l4;
        if (!PreferencesData.get((String)"target_platform").contentEquals("esp8266")) {
            System.err.println();
            this.editor.statusError("SPIFFS Not Supported on " + PreferencesData.get((String)"target_platform"));
            return;
        }
        if (!BaseNoGui.getBoardPreferences().containsKey((Object)"build.spiffs_start") || !BaseNoGui.getBoardPreferences().containsKey((Object)"build.spiffs_end")) {
            System.err.println();
            this.editor.statusError("SPIFFS Not Defined for " + (String)BaseNoGui.getBoardPreferences().get((Object)"name"));
            return;
        }
        try {
            l4 = this.getIntPref("build.spiffs_start");
            l3 = this.getIntPref("build.spiffs_end");
            l2 = this.getIntPref("build.spiffs_pagesize");
            if (l2 == 0L) {
                l2 = 256L;
            }
            if ((l = this.getIntPref("build.spiffs_blocksize")) == 0L) {
                l = 4096L;
            }
        }
        catch (Exception exception) {
            this.editor.statusError(exception);
            return;
        }
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        String string = PreferencesData.get((String)"runtime.os").contentEquals("windows") ? "mkspiffs.exe" : "mkspiffs";
        File file = new File(targetPlatform.getFolder() + "/tools", string);
        if (!(file.exists() && file.isFile() || (file = new File(targetPlatform.getFolder() + "/tools/mkspiffs", string)).exists() || (file = new File(PreferencesData.get((String)"runtime.tools.mkspiffs.path"), string)).exists())) {
            System.err.println();
            this.editor.statusError("SPIFFS Error: mkspiffs not found!");
            return;
        }
        Boolean bl = false;
        File file2 = new File(targetPlatform.getFolder() + "/tools");
        File file3 = new File(targetPlatform.getFolder() + "/tools");
        String string2 = PreferencesData.get((String)"serial.port");
        String string3 = PreferencesData.get((String)"runtime.os").contentEquals("windows") ? "python3.exe" : "python3";
        String string4 = "";
        if (string2 == null || string2.isEmpty()) {
            System.err.println();
            this.editor.statusError("SPIFFS Error: serial port not defined!");
            return;
        }
        File file4 = new File(targetPlatform.getFolder() + "/tools", "upload.py");
        if (file4.exists() && file4.isFile()) {
            string4 = file4.getAbsolutePath();
        }
        for (String string5 : stringArray = new String[]{targetPlatform.getFolder() + "/tools", targetPlatform.getFolder() + "/tools/python3", PreferencesData.get((String)"runtime.tools.python3.path")}) {
            object = new File(string5, string3);
            if (!((File)object).exists() || !((File)object).isFile() || !((File)object).canExecute()) continue;
            string3 = ((File)object).getAbsolutePath();
            break;
        }
        if (string2.split("\\.").length == 4) {
            bl = true;
            String n = "espota.py";
            file2 = new File(targetPlatform.getFolder() + "/tools", n);
            if (!file2.exists() || !file2.isFile()) {
                System.err.println();
                this.editor.statusError("SPIFFS Error: espota not found!");
                return;
            }
        } else {
            String string6 = (String)targetPlatform.getTool("esptool").get((Object)"cmd");
            file3 = new File(targetPlatform.getFolder() + "/tools", string6);
            if (!(file3.exists() && file3.isFile() || (file3 = new File(targetPlatform.getFolder() + "/tools/esptool", string6)).exists() || (file3 = new File(PreferencesData.get((String)"runtime.tools.esptool.path"), string6)).exists() || !string4.isEmpty())) {
                System.err.println();
                this.editor.statusError("SPIFFS Error: esptool not found!");
                return;
            }
        }
        boolean bl2 = false;
        File file5 = new File(this.editor.getSketch().getFolder(), "data");
        if (!file5.exists()) {
            file5.mkdirs();
        }
        if (file5.exists() && file5.isDirectory() && (fileArray = file5.listFiles()).length > 0) {
            for (File file6 : fileArray) {
                if (!file6.isDirectory() && !file6.isFile() || file6.getName().startsWith(".")) continue;
                ++var20_22;
            }
        }
        String string7 = file5.getAbsolutePath();
        String string8 = file.getAbsolutePath();
        object = this.editor.getSketch().getName();
        String string9 = this.getBuildFolderPath(this.editor.getSketch()) + "/" + (String)object + ".spiffs.bin";
        String string10 = (String)BaseNoGui.getBoardPreferences().get((Object)"upload.resetmethod");
        String string11 = (String)BaseNoGui.getBoardPreferences().get((Object)"upload.speed");
        String string12 = (String)BaseNoGui.getBoardPreferences().get((Object)"build.spiffs_start");
        Object[] objectArray = new Object[]{"Yes", "No"};
        String string13 = "SPIFFS Create";
        String string14 = "No files have been found in your data folder!\nAre you sure you want to create an empty SPIFFS image?";
        if (var20_22 == false && JOptionPane.showOptionDialog((Component)this.editor, string14, string13, 0, 3, null, objectArray, objectArray[1]) != 0) {
            System.err.println();
            this.editor.statusError("SPIFFS Warning: mkspiffs canceled!");
            return;
        }
        this.editor.statusNotice("SPIFFS Creating Image...");
        System.out.println("[SPIFFS] data    : " + string7);
        System.out.println("[SPIFFS] size    : " + (l3 - l4) / 1024L);
        System.out.println("[SPIFFS] page    : " + l2);
        System.out.println("[SPIFFS] block   : " + l);
        try {
            if (this.listenOnProcess(new String[]{string8, "-c", string7, "-p", l2 + "", "-b", l + "", "-s", l3 - l4 + "", string9}) != 0) {
                System.err.println();
                this.editor.statusError("SPIFFS Create Failed!");
                return;
            }
        }
        catch (Exception exception) {
            this.editor.statusError(exception);
            this.editor.statusError("SPIFFS Create Failed!");
            return;
        }
        this.editor.statusNotice("SPIFFS Uploading Image...");
        System.out.println("[SPIFFS] upload  : " + string9);
        if (bl.booleanValue()) {
            System.out.println("[SPIFFS] IP       : " + string2);
            System.out.println();
            this.sysExec(new String[]{string3, file2.getAbsolutePath(), "-i", string2, "-s", "-f", string9});
        } else {
            System.out.println("[SPIFFS] address  : " + string12);
            System.out.println("[SPIFFS] reset    : " + string10);
            System.out.println("[SPIFFS] port     : " + string2);
            System.out.println("[SPIFFS] speed    : " + string11);
            if (!string4.isEmpty()) {
                System.out.println("[SPIFFS] python   : " + string3);
                System.out.println("[SPIFFS] uploader : " + string4);
            }
            System.out.println();
            if (!string4.isEmpty()) {
                this.sysExec(new String[]{string3, string4, "--chip", "esp8266", "--port", string2, "--baud", string11, "write_flash", string12, string9});
            } else {
                this.sysExec(new String[]{file3.getAbsolutePath(), "-cd", string10, "-cb", string11, "-cp", string2, "-ca", string12, "-cf", string9});
            }
        }
    }

    public void run() {
        this.createAndUpload();
    }
}

