#include <Arduino.h>

// defines pins numbers
const int red = 18;
const int green = 19;
const int blue = 21;
const int freq = 5000;
const int ledChannel = 0;
const int ledChannelGreen = 1;
const int ledChannelBlue = 2;
const int resolution = 8;
const int trigPin = 4;
const int echoPin = 5;
int distance;
int timer;
int playing = 0;
long duration;

void setup() {
  pinMode(trigPin, OUTPUT); // Sets the trigPin as an Output
  pinMode(echoPin, INPUT); // Sets the echoPin as an Input
  // configure LED PWM functionalitites
  ledcSetup(ledChannel, freq, resolution);
  ledcAttachPin(red, ledChannel);
  ledcSetup(ledChannelGreen, freq, resolution);
  ledcAttachPin(green, ledChannelGreen);
  ledcSetup(ledChannelBlue, freq, resolution);
  ledcAttachPin(blue, ledChannelBlue);
  Serial.begin(9600); // Starts the serial communication
}


void loop() {
  // Clears the trigPin
  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);
  
  // Sets the trigPin on HIGH state for 10 micro seconds
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);
  
  // Reads the echoPin, returns the sound wave travel time in microseconds
  duration = pulseIn(echoPin, HIGH);
  
  // Calculating the distance
  distance= duration*0.034/2;
  
  // Prints the distance on the Serial Monitor
  Serial.print("Distance: ");
  Serial.println(distance);

  if( distance < 40 )
  {
    // increase the LED brightness
    for(int dutyCycle = 0; dutyCycle <= (distance); dutyCycle++) {   
      // changing the LED brightness with PWM
      ledcWrite(ledChannel, dutyCycle);
      delay(distance);
    } 
    // decrease the LED brightness
    for(int dutyCycle = (distance); dutyCycle >= 0; dutyCycle--) {
      // changing the LED brightness with PWM
      ledcWrite(ledChannel, dutyCycle);   
      delay(distance / 2);
    }
  }
    if( distance < 80 )
  {
    // increase the LED brightness
    for(int dutyCycle = 0; dutyCycle <= (distance); dutyCycle++) {   
      // changing the LED brightness with PWM
      ledcWrite(ledChannelBlue, dutyCycle);
      delay(distance / 4);
    } 
    // decrease the LED brightness
    for(int dutyCycle = (distance); dutyCycle >= 0; dutyCycle--) {
      ledcWrite(ledChannelBlue, dutyCycle);   
      delay(distance / 1.5);
    }
  }
}
